/*
 * (c) 2023-2024 Jens Mueller
 *
 * JKCLOAD
 *
 * Tabellenmodell fuer die eingelesenen Dateien
 */

package jkcload.ui;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;


public class FileTableModel extends AbstractTableModel
{
  private static final String[] colNames = {
					"Format",
					"Adresse",
					"L\u00E4nge",
					"Startadr.",
					"Name",
					"Info",
					"Status",
					"Speicherbar als",
					"Gespeichert" };

  private List<FileData> rows;


  public FileTableModel()
  {
    this.rows = new ArrayList<>();
  }


  public void addRow( FileData fileData )
  {
    int rowIdx = this.rows.size();
    this.rows.add( fileData );
    fireTableRowsInserted( rowIdx, rowIdx );
  }


  public void clear()
  {
    this.rows.clear();
    fireTableDataChanged();
  }


  public Color getBgColorAt( int rowIdx, int colIdx )
  {
    Color color = null;
    if( (rowIdx >= 0) && (rowIdx < this.rows.size()) && (colIdx == 6) ) {
      FileData fileData = this.rows.get( rowIdx );
      if( fileData.hasError() ) {
	color = Color.RED;
      } else {
	color = Color.GREEN;
      }
    }
    return color;
  }


  public Color getFgColorAt( int rowIdx, int colIdx )
  {
    Color color = null;
    if( (rowIdx >= 0) && (rowIdx < this.rows.size()) && (colIdx == 6) ) {
      FileData fileData = this.rows.get( rowIdx );
      if( fileData.hasError() ) {
	color = Color.WHITE;
      } else {
	color = Color.BLACK;
      }
    }
    return color;
  }


  public FileData getRow( int rowIdx )
  {
    return (rowIdx >= 0) && (rowIdx < this.rows.size()) ?
					this.rows.get( rowIdx )
					: null;
  }


  public boolean isEmpty()
  {
    return this.rows.isEmpty();
  }


  public void removeRow( int rowIdx )
  {
    if( (rowIdx >= 0) && (rowIdx < this.rows.size()) ) {
      this.rows.remove( rowIdx );
      fireTableRowsDeleted( rowIdx, rowIdx );
    }
  }


	/* --- TableModel --- */

  @Override
  public Class<?> getColumnClass( int colIdx )
  {
    Class<?> rv = Object.class;
    switch( colIdx ) {
      case 0:
      case 1:
      case 2:
      case 3:
      case 4:
      case 5:
      case 6:
      case 7:
	rv = String.class;
	break;
      case 8:
	rv = Boolean.class;
	break;
    }
    return rv;
  }


  @Override
  public int getColumnCount()
  {
    return colNames.length;
  }


  @Override
  public String getColumnName( int colIdx )
  {
    return (colIdx >= 0) && (colIdx < colNames.length) ?
						colNames[ colIdx ]
						: null;
  }


  @Override
  public int getRowCount()
  {
    return this.rows.size();
  }


  @Override
  public Object getValueAt( int rowIdx, int colIdx )
  {
    Object rv = null;
    if( (rowIdx >= 0) && (rowIdx < this.rows.size()) ) {
      FileData fileData = this.rows.get( rowIdx );
      switch( colIdx ) {
	case 0:
	  rv = fileData.getFormat();
	  break;
	case 1:
	  rv = fileData.getBegAddrText();
	  break;
	case 2:
	  rv = fileData.getDataLengthText();
	  break;
	case 3:
	  rv = fileData.getStartAddrText();
	  break;
	case 4:
	  rv = fileData.getFileName();
	  break;
	case 5:
	  rv = fileData.getInfoText();
	  break;
	case 6:
	  rv = fileData.getStatusText();
	  break;
	case 7:
	  rv = fileData.getFileExtensionsText();
	  break;
	case 8:
	  rv = fileData.isSaved();
	  break;
      }
    }
    return rv;
  }


  @Override
  public boolean isCellEditable( int rowIdx, int colIdx )
  {
    return false;
  }
}
