/*
 * (c) 2023 Jens Mueller
 *
 * JKCLOAD
 *
 * Renderer mit Farbunterstuetzung fuer die Dateitabelle
 */

package jkcload.ui;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;


public class FileTableCellRenderer extends DefaultTableCellRenderer
{
  private Color bgColor;
  private Color fgColor;


  public FileTableCellRenderer()
  {
    this.bgColor = getBackground();
    this.fgColor = getForeground();
  }


	/* --- ueberschriebene Methoden --- */

  @Override
  public Component getTableCellRendererComponent(
						JTable  table,
						Object  value,
						boolean selected,
						boolean hasFocus,
						int     rowIdx,
						int     colIdx )
  {
    Component c = super.getTableCellRendererComponent(
						table,
						value,
						selected,
						hasFocus,
						rowIdx,
						colIdx );
    // Hintergrudfarbe setzen
    if( !selected && (c != null) ) {
      if( c instanceof JComponent ) {
	Color bgColor = null;
	Color fgColor = null;
	if( table != null ) {
	  TableModel tm = table.getModel();
	  if( tm != null ) {
	    if( tm instanceof FileTableModel ) {
	      bgColor = ((FileTableModel) tm).getBgColorAt(
							rowIdx,
							colIdx );
	      fgColor = ((FileTableModel) tm).getFgColorAt(
							rowIdx,
							colIdx );
	    }
	  }
	}
	((JComponent) c).setBackground(
				bgColor != null ? bgColor : this.bgColor );
	((JComponent) c).setForeground(
				fgColor != null ? fgColor : this.fgColor );
      }
    }
    return c;
  }
}
