/*
 * (c) 2023 Jens Mueller
 *
 * JKCLOAD
 *
 * Auswahldialog fuer einen Kanal
 */

package jkcload.ui;

import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.regex.PatternSyntaxException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;


public class ChannelSelectFld extends JPanel
{
  private JRadioButton rbLeft;
  private JRadioButton rbRight;


  public ChannelSelectFld( String msg, int defaultChannel )
  {
    setLayout( new GridBagLayout() );

    GridBagConstraints gbc = new GridBagConstraints(
					0, 0,
					1, 1,
					0.0, 0.0,
					GridBagConstraints.WEST,
					GridBagConstraints.NONE,
					new Insets( 5, 5, 0, 5 ),
					0, 0 );
    if( msg != null ) {
      try {
	for( String line : msg.split( "\n" ) ) {
	  add( new JLabel( line ), gbc );
	  gbc.insets.top = 0;
	  gbc.gridy++;
	}
      }
      catch( PatternSyntaxException ex ) {}
    }

    JPanel panelBtn = new JPanel();
    panelBtn.setLayout( new BoxLayout( panelBtn, BoxLayout.X_AXIS ) );
    gbc.anchor        = GridBagConstraints.CENTER;
    gbc.insets.top    = 5;
    gbc.insets.bottom = 5;
    gbc.gridy++;
    add( panelBtn, gbc );

    ButtonGroup grpChannel = new ButtonGroup();

    this.rbLeft = new JRadioButton( "Links", defaultChannel != 1 );
    grpChannel.add( this.rbLeft );
    panelBtn.add( this.rbLeft );

    panelBtn.add( Box.createHorizontalStrut( 5 ) );

    this.rbRight = new JRadioButton( "Rechts", defaultChannel == 1 );
    grpChannel.add( this.rbRight );
    panelBtn.add( this.rbRight );
  }


  public int getSelectedChannel()
  {
    return this.rbRight.isSelected() ? 1 : 0;
  }
}
