/*
 * (c) 2025 Jens Mueller
 *
 * JKCLOAD
 *
 * Dialog zum Aendern der BASICODE-Einstellungen 
 */

package jkcload.ui;

import java.awt.Dialog;
import java.awt.GridLayout;
import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowListener;
import java.awt.event.WindowEvent;
import java.util.Properties;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import jkcload.Main;
import jkcload.audio.BCAudioProcessor;


public class BCSettingsDlg extends JDialog implements ActionListener
{
  private static final String PROP_PREFIX = Main.PROP_PREFIX + "settings.bc";

  private JButton        btnOK;
  private JButton        btnCancel;
  private JRadioButton   rbEolCRNL;
  private JRadioButton   rbEolNL;
  private JRadioButton   rbEolRaw;
  private JCheckBox      cbRemoveEmptyLines;
  private WindowListener windowListener;


  public static void open( Window owner )
  {
    (new BCSettingsDlg( owner )).setVisible( true );
  }


	/* --- ActionListener --- */

  @Override
  public void actionPerformed( ActionEvent e )
  {
    Object src = e.getSource();
    if( (src == this.rbEolCRNL)
	|| (src == this.rbEolNL)
	|| (src == this.rbEolRaw) )
    {
      updRemoveEmptyLinesEnabled();
    } else if( src == this.btnOK ) {
      doApply();
    } else if( src == this.btnCancel ) {
      doClose();
    }
  }


	/* --- Konstruktor --- */

  private BCSettingsDlg( Window owner )
  {
    super(
	owner,
	"BASICODE-Einstellungen",
	Dialog.ModalityType.DOCUMENT_MODAL );
    setDefaultCloseOperation( JDialog.DO_NOTHING_ON_CLOSE );
    UIUtil.setIconImagesAt( this );


    // Fensterinhalt
    setLayout( new GridBagLayout() );

    GridBagConstraints gbc = new GridBagConstraints(
					0, 0,
					1, 1,
					0.0, 0.0,
					GridBagConstraints.WEST,
					GridBagConstraints.NONE,
					new Insets( 5, 5, 0, 5 ),
					0, 0 );

    add( new JLabel( "Zeilenendebytes der BASICODE-Programme:" ), gbc );

    ButtonGroup grpEOL = new ButtonGroup();

    this.rbEolCRNL  = new JRadioButton( "Standard (0Dh 0Ah)", true );
    grpEOL.add( this.rbEolCRNL );
    gbc.insets.left = 50;
    gbc.gridy++;
    add( this.rbEolCRNL, gbc );

    this.rbEolNL   = new JRadioButton( "Linux/Unix (0Ah)" );
    gbc.insets.top = 0;
    grpEOL.add( this.rbEolNL );
    gbc.gridy++;
    add( this.rbEolNL, gbc );

    this.rbEolRaw = new JRadioButton( "So wie eingelesen" );
    grpEOL.add( this.rbEolRaw );
    gbc.gridy++;
    add( this.rbEolRaw, gbc );

    this.cbRemoveEmptyLines = new JCheckBox( "Leerzeilen entfernen" );
    gbc.anchor              = GridBagConstraints.CENTER;
    gbc.insets.top          = 10;
    gbc.insets.left         = 5;
    gbc.gridy++;
    add( this.cbRemoveEmptyLines, gbc );

    JPanel panelBtn   = new JPanel( new GridLayout( 1, 2, 5, 5 ) );
    gbc.insets.bottom = 10;
    gbc.fill          = GridBagConstraints.NONE;
    gbc.gridy++;
    add( panelBtn, gbc );

    this.btnOK = new JButton( "OK" );
    panelBtn.add( this.btnOK );

    this.btnCancel = new JButton( "Abbrechen" );
    panelBtn.add( this.btnCancel );


    // Voreinstellungen
    String eol = Main.getProperty( BCAudioProcessor.PROP_PRG_EOL );
    if( eol != null ) {
      switch( eol ) {
	case BCAudioProcessor.VALUE_NL:
	  this.rbEolNL.setSelected( true );
	  break;
	case BCAudioProcessor.VALUE_RAW:
	  this.rbEolRaw.setSelected( true );
	  break;
      }
    }
    String rmEmptyLines = Main.getProperty(
				BCAudioProcessor.PROP_PRG_RM_EMPTY_LINES );
    if( rmEmptyLines != null ) {
      this.cbRemoveEmptyLines.setSelected(
				Boolean.parseBoolean( rmEmptyLines ) );
    }
    updRemoveEmptyLinesEnabled();


    // Fenstergroesse und -position
    pack();
    setResizable( false );
    if( !UIUtil.restoreWindowBounds(
			this,
			Main.getProperties(),
			PROP_PREFIX ) )
    {
      setLocationByPlatform( true );
    }

    // Listener
    this.rbEolCRNL.addActionListener( this );
    this.rbEolNL.addActionListener( this );
    this.rbEolRaw.addActionListener( this );
    this.btnOK.addActionListener( this );
    this.btnCancel.addActionListener( this );
    this.windowListener = new WindowAdapter()
		{
		  @Override
		  public void windowClosing( WindowEvent e )
		  {
		    doClose();
		  }
		};
    addWindowListener( this.windowListener );
  }


	/* --- private Methoden --- */

  private void doClose()
  {
    UIUtil.getWindowBounds(
			this,
			Main.getProperties(),
			PROP_PREFIX );
    this.rbEolCRNL.removeActionListener( this );
    this.rbEolNL.removeActionListener( this );
    this.rbEolRaw.removeActionListener( this );
    this.btnOK.removeActionListener( this );
    this.btnCancel.removeActionListener( this );
    removeWindowListener( this.windowListener );
    setVisible( false );
    dispose();
  }


  private void doApply()
  {
    String eol = BCAudioProcessor.VALUE_CRNL;
    if( this.rbEolNL.isSelected() ) {
      eol = BCAudioProcessor.VALUE_NL;
    } else if( this.rbEolRaw.isSelected() ) {
      eol = BCAudioProcessor.VALUE_RAW;
    }
    Main.getProperties().setProperty( BCAudioProcessor.PROP_PRG_EOL, eol );
    Main.getProperties().setProperty(
		BCAudioProcessor.PROP_PRG_RM_EMPTY_LINES,
		String.valueOf( this.cbRemoveEmptyLines.isSelected() ) );
    doClose();
  }


  private void updRemoveEmptyLinesEnabled()
  {
    this.cbRemoveEmptyLines.setEnabled(
		this.rbEolCRNL.isSelected() || this.rbEolNL.isSelected() );
  }
}
