/*
 * (c) 2023-2025 Jens Mueller
 *
 * JKCLOAD
 *
 * Einstellungen fuer die Signalauswertung
 *
 * Ist der Parameter "steepFlankStroke" gesetzt,
 * soll der Algorithmus zur Erkennung steiler Flanken verwendet werden.
 * Der in "steepFlankStroke" stehende Wert gibt dann an,
 * ab welcher relativen Hubhoehe eine steile Flanke
 * zu einem Phasenwechsel fuehrt.
 */

package jkcload.audio;


public class RecognitionSettings
{
  public enum Format {
	AC1( "AC1" ),
	SCCH( "AC1/LLC2-TurboSave (SCCH)" ),
	BASICODE( "BASICODE" ),
	BCS3_2_5MHz( "BCS3" ),
	BCS3_3_5MHz( "BCS3 mit 3,5 MHz" ),
	KC( "KCBASIC, KC85/1..5, KC87, HC900, Z9001, JU+TE mit EMR-ES 1988" ),
	Z1013_2MHz( "Z1013" ),
	Z1013_1MHz( "Z1013 mit 1 MHz" ),
	Z1013_4MHz( "Z1013 mit 4 MHz" ),
	ZX_SPECTRUM( "ZX Spectrum" );

    private String text;

    Format( String text )
    {
      this.text = text;
    }

    @Override
    public String toString()
    {
      return this.text;
    }
  };


  private Format format;
  private float  tolerance;
  private float  minLevel;
  private Float  steepFlankStroke;


  public RecognitionSettings(
			Format format,
			float  minLevel,
			float  tolerance,
			Float  steepFlankStroke )
  {
    this.format           = format;
    this.minLevel         = minLevel;
    this.tolerance        = tolerance;
    this.steepFlankStroke = steepFlankStroke;
  }


  public Format getFormat()
  {
    return this.format;
  }


  public float getMinLevel()
  {
    return this.minLevel;
  }


  public Float getSteepFlankStroke()
  {
    return this.steepFlankStroke;
  }


  public float getTolerance()
  {
    return this.tolerance;
  }
}
