/*
 * (c) 2023-2025 Jens Mueller
 *
 * JKCLOAD
 *
 * Erweiterter ByteArrayOutputStream,
 * bei dem man die hineingeschriebenen Daten wieder lesen
 * und auch nachtraeglich mit einer ODER-Verknuepfung veraendern kann
 */

package jkcload.audio;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;


public class ExtByteArrayOutputStream extends ByteArrayOutputStream
{
  public ExtByteArrayOutputStream( int size )
  {
    super( size );
  }


  public InputStream createInputStream()
  {
    return new ByteArrayInputStream( this.buf, 0, this.count );
  }


  public void orToEnd( int idx, int value )
  {
    while( idx < this.count ) {
      this.buf[ idx++ ] |= (byte) value;
    }
  }


  public void orToEnd( int idx, int value, int mask )
  {
    while( idx < this.count ) {
      this.buf[ idx ] = (byte) ((this.buf[ idx ] & ~mask) | (value & mask));
      idx++;
    }
  }
}
