/*
 * (c) 2023-2025 Jens Mueller
 *
 * JKCLOAD
 *
 * Programmstart
 */

package jkcload;

import java.awt.EventQueue;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import javax.swing.UIManager;
import jkcload.ui.UIUtil;
import jkcload.ui.LoadFrm;


public class Main
{
  public static final String APPNAME     = "JKCLOAD";
  public static final String VERSION     = "1.3";
  public static final String COPYRIGHT   = "(c) 2023-2025 Jens M\u00FCller";
  public static final String PROP_PREFIX = "jkcload.";

  private static final String SETTINGS_FILENAME = "jkcload.cfg";

  private static Properties properties   = new Properties();
  private static File       settingsFile = null;


  public static Properties getProperties()
  {
    return properties;
  }


  public static String getProperty( String keyword )
  {
    return properties.getProperty( keyword );
  }


  public static File getSettingsFile()
  {
    return settingsFile;
  }


  public static void main( String[] args )
  {
    // Konfigurationsdatei festlegen und einlesen
    Exception propEx     = null;
    String    appDataDir = emptyToNull( System.getenv( "APPDATA" ) );
    if( appDataDir != null ) {
      settingsFile = new File( appDataDir, SETTINGS_FILENAME );
    } else {
      String homeDir = emptyToNull( System.getProperty( "user.home" ) );
      if( homeDir != null ) {
	if( File.separatorChar == '/' ) {
	  settingsFile = new File( homeDir, "." + SETTINGS_FILENAME );
	} else {
	  settingsFile = new File( homeDir, SETTINGS_FILENAME );
	}
      }
    }
    if( settingsFile != null ) {
      if( settingsFile.exists() ) {
	try( InputStream in = new BufferedInputStream(
				new FileInputStream( settingsFile ) ) )
	{
	  properties.loadFromXML( in );
	}
	catch( Exception ex ) {
	  propEx = ex;
	}
      }
    }

    // Erscheinungsbild
    try {
      UIManager.put( "swing.boldMetal", Boolean.FALSE );
      UIManager.setLookAndFeel( UIManager.getSystemLookAndFeelClassName() );
    }
    catch( Exception ex ) {}

    // ggf. Fehlermeldung
    if( (settingsFile != null) && (propEx != null) ) {
      StringBuilder buf = new StringBuilder( 256 );
      buf.append( settingsFile.getPath() );
      buf.append( ":\nKonfigurationsdatei kann nicht gelesen werden." );
      UIUtil.fireShowErrorMsg( null, buf.toString(), propEx );
    }

    // Ladefenster oeffnen
    EventQueue.invokeLater( ()->(new LoadFrm()).setVisible( true ) );
  }


  public static void setProperty( String keyword, String value )
  {
    properties.setProperty( keyword, value != null ? value : "" );
  }


	/* --- private Methoden --- */

  private static String emptyToNull( String text )
  {
    if( text != null ) {
      if( text.isEmpty() ) {
	text = null;
      }
    }
    return text;
  }


	/* --- Konstruktor --- */

  private Main()
  {
    // nicht instanziierbar
  }
}
